##### Search Parameters
The following Appointment Search parameters are useful for querying Appointments or specifying Subscription criteria. See [HL7 FHIR R4](https://hl7.org/fhir/appointment.html#search) for the full list of Appointment search parameters including common parameters.

| Name | Type | Description | Expression |
| - | - | - | - |
| actor	| [reference](https://hl7.org/fhir/search.html#reference)	| Any one of the individuals participating in the appointment	| Appointment.participant.actor <br>(any actor type)
| date | [date](https://hl7.org/fhir/search.html#date) | Appointment date/time. | Appointment.start
| part-status | [token](https://hl7.org/fhir/search.html#token) | The Participation status of the subject, or other participant on the appointment. Can be used to locate participants that have not responded to meeting requests. | Appointment.participant.status
| status | [token](https://hl7.org/fhir/search.html#token) | The overall status of the appointment | Appointment.status
