### Electronic Theatre Bookings Profiles

#### Bookings Transaction Model

The FHIR Resources generated by the Magentus Bookings Service are shown in the diagram below.

<img src="EBookingsTransaction.png" width="100%">

#### Bookings Transaction Profiles

The FHIR Profiles for these resources are listed below.

| Magentus Profile | FHIR<sup>&reg;</sup> Resource | 
| ----------------------- | ----------------------------- | 
| [Bookings Appointment](StructureDefinition-ebookings-appointment.html) | [Appointment](http://hl7.org/fhir/R4/appointment.html) | 
| [Bookings ChargeItem](StructureDefinition-ebookings-chargeitem.html) | [ChargeItem](http://hl7.org/fhir/R4/chargeitem.html) | 
| [Bookings Consent](StructureDefinition-ebookings-consent.html) | [Consent](http://hl7.org/fhir/R4/consent.html) | 
| [Bookings Encounter](StructureDefinition-ebookings-encounter.html) | [Encounter](http://hl7.org/fhir/R4/encounter.html) | 
| [Bookings ServiceRequest](StructureDefinition-ebookings-servicerequest.html) | [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | 
| [Magentus HealthcareService](StructureDefinition-gs-healthcareservice.html) | [HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html) | 
| [Magentus Organization](StructureDefinition-gs-organization.html) | [Organization](http://hl7.org/fhir/R4/organization.html) | 
| [Magentus Patient](StructureDefinition-gs-patient.html) | [Patient](http://hl7.org/fhir/R4/patient.html) | 
| [Magentus Practitioner](StructureDefinition-gs-practitioner.html) | [Practitioner](http://hl7.org/fhir/R4/practitioner.html) | 
| [Magentus PractitionerRole](StructureDefinition-gs-practitionerrole.html) | [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) | 
{:.table}

Additional EBooking Resources are contained within the resources above, the FHIR profiles for these resources are listed below.

| Magentus Solutions Profile | FHIR<sup>&reg;</sup> Resource | 
| ----------------------- | ----------------------------- | 
| [Bookings Anaesthetic Request](StructureDefinition-ebookings-anaestheticrequest.html) | [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | 
| [Bookings Prosthesis](StructureDefinition-ebookings-prosthesis.html) | [Device](http://hl7.org/fhir/R4/device.html) | 
| [Magentus Coverage](StructureDefinition-gs-coverage.html) | [Coverage](http://hl7.org/fhir/R4/coverage.html) | 
{:.table}

#### Bookings Response Model

The FHIR Resources generated and referenced by the Bookings Partner are shown in the diagram below.

<img src="EBookingsAppointmentResponse.png" width="100%">

#### Bookings Response Profiles

The FHIR Profiles used by the Bookings Partner are listed below.

| Magentus Profile | FHIR<sup>&reg;</sup> Resource | 
| --------------------| ---------------------   | 
| [Bookings Appointment Response](StructureDefinition-ebookings-appointmentresponse.html) | [AppointmentResponse](http://hl7.org/fhir/R4/appointmentresponse.html) | 

### Bookings POST Notification Subscriptions

#### Registering a POST Notification Subscription
In order to receive subcription notifications from the FHIR Server when resources of interest are created or updated, a subscription is registered. A subscription request includes the following properties.

| Property | Description | Example |
| -------- | ----------- | ------- |
| criteria | Search criertia to match resources of interest | Appointment?status=pending,cancelled
| status   | Fixed: requested | requested
| channel.type | Fixed: rest-hook | rest-hook
| channel.endpoint | Web service URL where webhook is posted | https://webhook.site/bbd78ee4-e267-4633-8acc-38a5e1dc54a0 
| channel.header | Authorization header to be used in the subscription notification | Authorization: Bearer secret-token-abc-123
{:.table}

**Example**
The following exampl creates a new Subscription for the Appointment resource with a criteria on the status element filtering on the values of pending OR cancelled (Note: the comma delimitor between parameter values represents an OR, see https://hl7.org/fhir/r4/search.html#combining) 

    POST {{API_URL}}/Subscription

    {
      "resourceType": "Subscription",
      "criteria": "Appointment?status=pending,cancelled",
      "status": "requested",
      "reason": "Appointment pending and cancelled subscription",
      "channel": {
        "type": "rest-hook",
        "endpoint": "https://webhook.site/bbd78ee4-e267-4633-8acc-38a5e1dc54a0",
        "header": ["Authorization: Bearer secret-token-abc-123"]
      }
    }

The Subscription endpoint can also be used to Search, Read, Update and Delete as per the standard FHIR REST API pattern.

#### Subscription POST Notification
A subcription notification is received as a POST request on the endpoint specified in the subscription registration request. The POST request has an empty body.

**Example**

    POST https://webhook.site/bbd78ee4-e267-4633-8acc-38a5e1dc54a0
    Authorization: Bearer secret-token-abc-123
    
#### Responding to a Subscription Notification
The subscription notification shall respond as quickly as possible with a success status of 200 OK or 202 Accepted, and an empty body. The latter is normally returned when the request is accepted for processing but processing will commence after the response has been returned, which is the preferred approach for subscription notifications.

Any error response may result in a subsequent retry by the FHIR Server to submit the Subscription Notification until the number of retires is exceed at which time the FHIR Server will stop the subscription. See [Managing Subscriptions and Errors](https://hl7.org/fhir/subscription.html#errors) for more details.

#### Retreiving Subscription POST Notification Data

When a subscription notification is received, perform a Search request with the corresponding crieteria along with a _lastUpdated parameter with the timestamp when the last search request was performed with the gt prefix (see https://hl7.org/fhir/r4/search.html#prefix).

**Example**

    GET {{API_URL}}/Appointment?status=pending,cancelled&_lastUpdated=gt2022-12-13T12:30:00Z

##### Include Referenced Resources

In order to retrieve the entire Bookings transaction, use the following _include and _revinclude parameters.

| Parameter | Value |
| --------- | ----- |
| _include | Appointment:based-on
| _include | Appointment:actor
| _include:iterate | Patient:organization
| _include:iterate | ServiceRequest:requester
| _include:iterate | PractitionerRole:practitioner 
| _include:iterate | PractitionerRole:organization
| _revinclude:iterate | Encounter:based-on 
| _revinclude:iterate | ChargeItem:context 
| _revinclude:iterate | Consent:data 
{:.table}

**Example**

    GET {{API_URL}}/Appointment?status=pending,cancelled&_lastUpdated=gt2022-12-13T12:30:00Z&_include=Appointment:based-on&_include:iterate=ServiceRequest:requester&_include=Appointment:actor&_revinclude:iterate=Encounter:based-on&_revinclude:iterate=Consent:data&_include:iterate=Patient:organization&_revinclude:iterate=ChargeItem:context&_include:iterate=PractitionerRole:practitioner&_include:iterate=PractitionerRole:organization

An example search response is shown in [Bookings Appointment SearchSet Bundle](Bundle-BundleEBookingsSearchSet.html)

##### POST Search Request

Alternatively, the FHIR _search request using a HTTP POST may be used as shown in the following example.

**Example**

    POST {{API_URL}}/Appointment/_search
    Content-Type: application/x-www-form-urlencoded

    status=pending,cancelled
    _lastUpdated=gt2022-12-13T12:30:00Z
    _include=Appointment:based-on
    _include=iterate:ServiceRequest:requester
    _include=Appointment:actor
    _revinclude:iterate=Encounter:based-on
    _revinclude:iterate=Consent:data
    _include:iterate=Patient:organization
    _revinclude:iterate=ChargeItem:context
    _include:iterate=PractitionerRole:practitioner
    _include:iterate=PractitionerRole:organization

### Bookings PUT Notification Subscriptions
Alternativly, you can create a Subscription that executes a PUT notification request that contains the relative reference to the FHIR Resource that triggered the notification.

This approach may be preferred as it will enable the notification listener to retrieve only the specific resource that triggered notification and not need to manage the possibility of retreiving multiple resources to process as part of the notification's corresponding Search request.

#### Registering a PUT Notification Subscription
In order to receive subcription notifications from the FHIR Server with the resource reference that triggered the notification, use a subscription registration request with the following parameters.

| Property | Description | Example |
| -------- | ----------- | ------- |
| criteria | Search criertia to match resources of interest | Appointment?status=pending,cancelled |
| status   | Fixed: requested | requested |
| channel.type | Fixed: rest-hook | rest-hook |
| channel.endpoint | Web service URL where webhook is posted | https://webhook.site/bbd78ee4-e267-4633-8acc-38a5e1dc54a0 |
| channel.header | Authorization header to be used in the subscription notification | Authorization: Bearer secret-token-abc-123 |
| channel.payload | Fixed: application/fhir+json | application/fhir+json |
{:.table}

**Example**

    POST {{API_URL}}/Subscription

    {
      "resourceType": "Subscription",
      "criteria": "Appointment?status=pending,cancelled",
      "status": "requested",
      "reason": "Appointment pending and cancelled subscription with resource reference",
      "channel": {
        "type": "rest-hook",
        "endpoint": "https://webhook.site/bbd78ee4-e267-4633-8acc-38a5e1dc54a0",
        "header": ["Authorization: Bearer secret-token-abc-123"],
        "payload": "application/fhir+json"
      }
    }

#### Subscription PUT Notification
This subcription notification is received as a PUT request on the endpoint specified in the subscription registration request. The PUT request conatines the relative reference to the Resource that triggered the notification and an empty body.

**Example**

    PUT https://webhook.site/bbd78ee4-e267-4633-8acc-38a5e1dc54a0/Appointment/840fdd86-f273-4c56-89af-cc5dcda59
    Authorization: Bearer secret-token-abc-123

#### Retreiving Subscription PUT Notification Data

When a subscription PUT notification is received, you can retreive the referenced resource using a Search request with an _id parameter. Note that there is no need for the corresponding subscription criteria and _lastUpdated parameters as this request will directly retreive the specific resource that triggered the subscription.

**Example**

    GET {{API_URL}}/Appointment?_id=840fdd86-f273-4c56-89af-cc5dcda59

The _include and _revinclude parameters may also be used as described above.