The Magentus Reports Service accepts a transaction with a constrained set of FHIR Resources, including DiagnosticReport, based on AU Core R4 profiles. The Magentus Diagnostic Report transactions and associated AU Core Profiles are provided below.

| Magentus Profile | Parent Profile | FHIR<sup>&reg;</sup> Resource | 
| ------------------------| ----------------------------- | ----------------------------- | 
| [Diagnostic Imaging Report Transaction](StructureDefinition-gs-imagingreporttransaction.html) | [Bundle](http://hl7.org/fhir/R4/bundle.html) | [Bundle](http://hl7.org/fhir/R4/bundle.html) | 
| [Magentus Imaging Report Entry](StructureDefinition-gs-imagingreport-entry-report.html) | [AUCoreDiagnosticReport](http://hl7.org.au/fhir/core/0.2.2-preview/StructureDefinition-au-core-diagnosticreport.html) | [DiagnosticReport](http://hl7.org/fhir/R4/diagnosticreport.html) | 
| [Magentus Imaging Patient](StructureDefinition-gs-imagingreport-entry-patient.html) | [AUCorePatient](http://hl7.org.au/fhir/core/0.2.2-preview/StructureDefinition-au-core-patient.html) | [Patient](http://hl7.org/fhir/R4/patient.html) | 
| [Magentus Imaging Request](StructureDefinition-gs-imagingreport-entry-request.html) | [AUCoreServiceRequest](http://hl7.org.au/fhir/core/0.2.2-preview/StructureDefinition-au-core-servicerequest.html) | [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | 
| [Magentus Imaging Performer](StructureDefinition-gs-imagingreport-entry-performer.html) | [AUCoreOrganization](http://hl7.org.au/fhir/core/0.2.2-preview/StructureDefinition-au-core-organization.html) | [Organization](http://hl7.org/fhir/R4/organization.html) | 
| [Magentus Imaging Provider](StructureDefinition-gs-imagingreport-entry-provider.html) | [AUCorePractitionerRole](http://hl7.org.au/fhir/core/0.2.2-preview/StructureDefinition-au-core-practitionerrole.html) | [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) | 
{:.table}

Below are a list of example instances of Magentus Diagnostic Report transactions.

| Example Instance | 
| ------- | 
| [Diagnostic Imaging Report Bundle original example](Bundle-GSImagingReportTransactionExampleOriginal.html) | 
| [Inbound Imaging Diagnostic Report Transaction](Bundle-GSImagingReportTransactionExample.html) |
{:.table}
