### Electronic Diagnostic Request Profiles

The Magentus Requesting Service FHIR capability is specified in [Requesting Capability Statement](CapabilityStatement-eorders-capability.html).

#### Requesting Transaction Model

The FHIR Resources generated by the Magentus Requesting Service are shown in the diagram below.

<img src="ERequestTransaction.png" width="100%">

#### Claim Order Operation

The claim operation is used create a new fulfilment 'Task' for an alternate filler.  It cancels the original fulfilment 'Task', if it exists, but leaves the 'ServiceRequest' unchanged.  The original filler can determine that the order is being alternatively filled but not who is the alternative filler and similarly the alternate filler cannot determine who was the original filler.

[Diagnostic Service Claim Operation](OperationDefinition-EOrderClaimOperation.html)


#### Requesting Profiles
The FHIR Resources generated by the Magentus Requesting Service are listed below.  It should be noted that [Diagnostic Service Request](StructureDefinition-eorders-diagnosticrequest.html) should be regarded as a legacy profile and instead replaced by explicit [Pathology Request](StructureDefinition-eorders-pathologyrequest.html) and [Radiology Request](StructureDefinition-eorders-radiologyrequest.html).

| Magentus Profile | FHIR<sup>&reg;</sup> Resource | 
| ------------------------| ----------------------------- | 
| [Diagnostic Service Request](StructureDefinition-eorders-diagnosticrequest.html) | [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | 
| [Pathology Request](StructureDefinition-eorders-pathologyrequest.html) | [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | 
| [Radiology Request](StructureDefinition-eorders-radiologyrequest.html) | [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | 
| [Diagnostic Request Base](StructureDefinition-eorders-radiologyrequest.html) | [ServiceRequest](http://hl7.org/fhir/R4/servicerequest.html) | 
| [Diagnostic Request Group Task](StructureDefinition-eorders-task-fulfillment-group.html) | [Task](http://hl7.org/fhir/R4/task.html) | 
| [Diagnostic Request Task](StructureDefinition-eorders-diagnosticrequesttask.html) | [Task](http://hl7.org/fhir/R4/task.html) | 
| [Communication Request to Patient](StructureDefinition-eorders-communicationrequest-patient.html) | [CommunicationRequest](http://hl7.org/fhir/R4/communicationrequest.html) | 
| [Communication Request to Provider](StructureDefinition-eorders-communicationrequest-provider.html) | [CommunicationRequest](http://hl7.org/fhir/R4/communicationrequest.html) | 
| [Communication Request Task](StructureDefinition-eorders-task-communicationrequest.html) | [Task](http://hl7.org/fhir/R4/task.html) | 
| [Consent Withdrawl](StructureDefinition-eorders-consentwithdrawl.html) | [Consent](http://hl7.org/fhir/R4/consent.html) | 
| [Request PractitionerRole](StructureDefinition-eorders-practitionerrole.html) | [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) | 
| [Magentus HealthcareService](StructureDefinition-gs-healthcareservice.html) | [HealthcareService](http://hl7.org/fhir/R4/healthcareservice.html) | 
| [Magentus Organization](StructureDefinition-gs-organization.html) | [Organization](http://hl7.org/fhir/R4/organization.html) | 
| [Magentus Patient](StructureDefinition-gs-patient.html) | [Patient](http://hl7.org/fhir/R4/patient.html) | 
| [Magentus Practitioner](StructureDefinition-gs-practitioner.html) | [Practitioner](http://hl7.org/fhir/R4/practitioner.html) | 
{:.table}

Additional resources are contained within the Requesting resources above, the FHIR profiles for these resources are listed below.

| Profile | FHIR<sup>&reg;</sup> Resource | 
| ------- | ----------------------------- | 
| [AU Core Gestational Age](https://hl7.org.au/fhir/core/0.2.2-preview/StructureDefinition-au-core-gestationalage.html) | [Observation](http://hl7.org/fhir/R4/observation.html) | 
| [AU Core Last Menstrual Period](https://hl7.org.au/fhir/core/0.2.2-preview/StructureDefinition-au-core-lastmenstrualperiod.html) | [Observation](http://hl7.org/fhir/R4/observation.html) | 
| [Request Coverage](StructureDefinition-eorders-coverage.html) | [Coverage](http://hl7.org/fhir/R4/coverage.html) | 
| [Request Encounter](StructureDefinition-eorders-encounter.html) | [Encounter](http://hl7.org/fhir/R4/encounter.html) | 
| [Request PractitionerRole Contact](StructureDefinition-eorders-practitionerrole-contact.html) | [PractitionerRole](http://hl7.org/fhir/R4/practitionerrole.html) | 
| [UV IPS Observation (Pregnancy: status)](https://www.hl7.org/fhir/uv/ips/StructureDefinition-Observation-pregnancy-status-uv-ips.html) | [Observation](http://hl7.org/fhir/R4/observation.html) | 
{:.table}
