<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile Basic
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Basic</sch:title>
    <sch:rule context="f:Basic">
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-gross-amount']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-gross-amount': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-gross-amount']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-gross-amount': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-method']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-method': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-method']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-method': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-date']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-date': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-date']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-date': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice-lineitem']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice-lineitem': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice-lineitem']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/payment-invoice-lineitem': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Basic/f:identifier</sch:title>
    <sch:rule context="f:Basic/f:identifier">
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
      <sch:assert test="count(f:type) &lt;= 1">type: maximum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:system) &gt;= 1">system: minimum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:system) &lt;= 1">system: maximum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:period) &lt;= 1">period: maximum cardinality of 'period' is 1</sch:assert>
      <sch:assert test="count(f:assigner) &lt;= 1">assigner: maximum cardinality of 'assigner' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
