<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile List
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:List</sch:title>
    <sch:rule context="f:List">
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-hospital-ext']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-hospital-ext': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-hospital-ext']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-hospital-ext': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-vmo-ext']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-vmo-ext': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-vmo-ext']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-vmo-ext': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-period-ext']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-period-ext': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-period-ext']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-period-ext': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-status-ext']) &gt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-status-ext': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-status-ext']) &lt;= 1">extension with URL = 'http://fhir.geniesolutions.io/StructureDefinition/ebookings-theatre-list-status-ext': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:subject) &lt;= 0">subject: maximum cardinality of 'subject' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:date) &gt;= 1">date: minimum cardinality of 'date' is 1</sch:assert>
      <sch:assert test="count(f:entry) &gt;= 1">entry: minimum cardinality of 'entry' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:List/f:code</sch:title>
    <sch:rule context="f:List/f:code">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:coding) &gt;= 1">coding: minimum cardinality of 'coding' is 1</sch:assert>
      <sch:assert test="count(f:coding) &lt;= 1">coding: maximum cardinality of 'coding' is 1</sch:assert>
      <sch:assert test="count(f:text) &lt;= 1">text: maximum cardinality of 'text' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
